//Simulation of CDMA (Code Division Multiplexing and Demultiplexing) Technique 
// OS-Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad

clear; 
clc;
close;


W = input("Enter total RF bandwidth W in Hz (e.g., 1.25e6 for 1.25 MHz): ");
R = input("Enter data rate R per user in Hz (e.g., 4800, 9600, 19200): ");
Eb_N0 = input("Enter Eb/N0 in dB (suggested range: 5 to 15 dB): ");
eta = input("Enter background noise fraction η (suggested range: 0.5 to 1): ");
alpha = input("Enter voice activity factor α (suggested range: 0.3 to 1): ");
sectorization_factor = input("Enter antenna sectorization factor (1 for omni, 3 for 120° beamwidth): ");

// Convert Eb/N0 from dB to linear
Eb_N0_linear = 10^(Eb_N0/10);

S = 1; // Assume desired signal power S = 1 unit
N_basic = 1 + (W/R) / (Eb_N0_linear * (eta/S));

// Apply sectorization and voice activity factor
N_sector = (N_basic - 1) * alpha + (eta/S);
Eb_N0_sector = (W/R) / N_sector;

// Final capacity with sectoring and voice activity
N_final = 1 + (W/R) / Eb_N0_sector; 

disp("========== CDMA Capacity Results ==========");
disp("Processing Gain (W/R): " + string(W/R));
disp("Eb/N0 (linear): " + string(Eb_N0_linear));
disp("Estimated basic user capacity (no interference control): " + string(N_basic));
disp("Eb/N0 within sector with interference control: " + string(Eb_N0_sector));
disp("Estimated final user capacity (with sectorization and voice activity): " + string(N_final));

eb_range = 5:1:15;
N_plot = [];
for eb = eb_range
    EbN0_lin = 10^(eb/10);
    N_temp = 1 + (W/R) / (EbN0_lin * (eta/S));
    N_plot($+1) = N_temp;
end

scf(0);
plot(eb_range, N_plot);
xlabel("Eb/N0 (dB)");
ylabel("CDMA Capacity (Users)");
title("Effect of Eb/N0 on CDMA Capacity");
xtitle("CDMA Capacity vs Eb/N0");

// Description of the Figure
// User Inputs:
// Enter total RF bandwidth W in Hz (e.g., 1.25e6 for 1.25 MHz): 1.5e6
// Enter data rate R per user in Hz (e.g., 4800, 9600, 19200): 9600
// Enter Eb/N0 in dB (suggested range: 5 to 15 dB): 8
// Enter background noise fraction η (suggested range: 0.5 to 1): 0.8
// Enter voice activity factor α (suggested range: 0.3 to 1): 0.5
// Enter antenna sectorization factor (1 for omni, 3 for 120° beamwidth): 3
// The figure titled "CDMA Capacity vs Eb/N0" represents how the user capacity of a CDMA system changes with respect to the energy-per-bit to noise power spectral density ratio.

